function [logL, lik]=TCopDVineLL(phi,data,optimizer)
% The log likelihood of a D-Vine, assuming T - Copula for all pairs
% INPUTS:
% theta:        A column vector of parameters for the copulas, of size
%               N(N-1)/2, where N are the columns of data
% data:         A TxN matrix of U(0,1) or iid margins. If you supply iid
%               margins (eg the residuals from some GARCH filtration),
%               these are transformed to uniform via the empiricalCDF
%               function
% OUTPUTS:
% logL:         The negative log likelihood of the Vine
% lik:          The log likelihoods from each paired T - Copula
if nargin==2
    optimizer='fmincon';
end
if min(min(data))<0 || max(max(data))>1
    data=empiricalCDF(data);
end
[T,N]=size(data);
lik=zeros(N-1,N-1);
u=cell(N,N);
if size(phi,1)~=N-1 || size(phi,2)~=N-1
    if size(phi,1)==N*(N-1)/2 && size(phi,2)==1
    phi=crIPmat(phi);
    else
    error('the parameters vector should be square of N-1 size, or a column vector with N(N_1)/2 rows')
    end
end
theta=zeros(size(phi));
for i=1:N-1
    [lik(1,i), theta(1,i)]=StaticTCopulaLL(phi(1,i),[data(:,i) data(:,i+1)],optimizer);
end
rho=corr([data(:,1) data(:,2)]); rho=rho(1,2);
u{1,1}=hfuncTC(data(:,1),data(:,2),theta(1,1),rho);
for k=1:N-3
    rho=corr([data(:,k+1),data(:,k+2)]); rho=rho(1,2);
    u{1,2*k}=hfuncTC(data(:,k+2),data(:,k+1),theta(1,k+1),rho);
    u{1,2*k+1}=hfuncTC(data(:,k+1),data(:,k+2),theta(1,k+1),rho);
end
rho=corr([data(:,N),data(:,N-1)]); rho=rho(1,2);
u{1,2*N-4}=hfuncTC(data(:,N),data(:,N-1),theta(1,N-1),rho);
for j=2:(N-1)
    for i=1:(N-j)
        [lik(j,i), theta(j,i)]=StaticTCopulaLL(phi(j,i),[u{j-1,2*i-1} u{j-1,2*i}],optimizer);
    end
    if j<N-1
    rho=corr([u{j-1,1},u{j-1,2}]); rho=rho(1,2);
    u{j,1}=hfuncTC(u{j-1,1},u{j-1,2},theta(j,1),rho); 
    if N>4
        for i=1:(N-j-2)
        rho=corr([u{j-1,2*i+2},u{j-1,2*i+1}]); rho=rho(1,2);
        u{j,2*i}=hfuncTC(u{j-1,2*i+2},u{j-1,2*i+1},theta(j,i+1),rho);
        u{j,2*i+1}=hfuncTC(u{j-1,2*i+1},u{j-1,2*i+2},theta(j,i+1),rho);
        end
    end
    rho=corr([u{j-1,2*N-2*j},u{j-1,2*N-2*j-1}]); rho=rho(1,2);
    u{j,2*N-2*j-2}=hfuncTC(u{j-1,2*N-2*j},u{j-1,2*N-2*j-1},theta(j,N-j),rho);
    end
end
logL=sum(sum(lik)); 

        
        
        
    
    